org 100h
  mov al,13h

  add dh,al
  mov ds,dx  ; Pos (s16)
  add dh,al
  mov gs,dx  ; Old Pos = Vel
  add dh,al
  mov fs,dx  ; Caustics
  push 0xa000
  pop es     ; Screen

  cwd  ; dx=0
P int 10h
  mov ax,0x1010 ; set palette: bl=index dh=R ch=G cl=B
  add dx,0x30
  imul cx,dx,2
  cmp ch,63
  jna PH
  mov ch,63
PH:
  mov cl,ch
  add cl,dh
  cmp cl,63
  jna PA
  mov cl,63
PA:
  inc bl
  jnz P

  xor si,si
I mov [si],bl    ; Pos=0
  mov [gs:si],bl ; Vel=0
  inc si
  jnz I
  
  mov cx,0x503

; dx,bp=time si=0 cl=3
M:

; add a drop
  push dx
  and dh,cl
  inc dh
  sub bp,dx
  pop dx
  jnc DINC
  imul di,dx,2
  add word[di],0x1500
  imul dx,85
  inc dx
DINC:

  pusha


; water ripple
;      2/3
; 1/3 -old  1/3
;      2/3
O:
  mov ax,[si+320]
  add ax,[si-320]
  add ax,ax
  add ax,[si+2]
  add ax,[si-2]
  mov dx,65535/3
  imul dx
  sub dx,[gs:si]
  mov bx,dx
  sar dx,12
  sub bx,dx
  mov [gs:si],bx

  mov di,bx
  sub di,[gs:si-320]
  sar di,2
  imul di,320
  add di,si

  push bx
  sub bx,[gs:si-2]
  sar bx,2
  add byte[fs:bx+di],ch
  add byte[fs:bx+di+1],ch

  pop bx
  sub bx,[si-2]
  sar bx,2
  add byte[fs:bx+di],ch
  add byte[fs:bx+di+1],ch
  
  inc si
  inc si
  jnz O
  
  push ds
  push gs
  pop ds
  pop gs

  xor ax,ax
S:
  mov bx,[si+2]
  mov dx,[si]
  add dx,bx
  shr dx,cl

  sub bx,[si]

  sar bx,cl
  sub bx,si
  and bx,32      ; background stripes

  fs lodsb       ; si+=1
  add al,[fs:si]
  add al,48
  add al,dl
  add al,bl

  mov [es:si],al
  
  xchg al,ah
  add al,ah
  rcr al,1
  mov [es:si-1],al

  inc si
  jnz S

; fade out caustics
F shr byte[fs:si],1
  inc si
  jnz F

; vwait
  mov dx,0x3da
V in al,dx
  test al,8
  jnz V
W in al,dx
  test al,8
  jz W

  popa
  
  call SCREENSHOT

  in al,60h
  dec al
  jnz M

  ret

%include "screenshot.inc"